<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iniciar sesión | Yaca Aventura</title>
    <style>
        /* ==== Reset ==== */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: "Poppins", sans-serif;
        }

        body {
            height: 100vh;
            background: linear-gradient(135deg, #1e6091, #184e77, #76c893);
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            color: #333;
        }

        /* ==== Fondo con capa difusa ==== */
        body::before {
            content: "";
            position: absolute;
            inset: 0;
            background: url('https://images.unsplash.com/photo-1507525428034-b723cf961d3e?auto=format&fit=crop&w=1400&q=80') no-repeat center center/cover;
            opacity: 0.25;
            z-index: -1;
            filter: blur(5px);
        }

        /* ==== Tarjeta principal ==== */
        .login-container {
            background: rgba(255, 255, 255, 0.95);
            padding: 3rem 2.5rem;
            border-radius: 16px;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.2);
            width: 380px;
            text-align: center;
            animation: slideIn 0.8s ease;
        }

        @keyframes slideIn {
            from { opacity: 0; transform: translateY(25px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .login-container h2 {
            color: #184e77;
            margin-bottom: 0.25rem;
            font-weight: 700;
            letter-spacing: 0.5px;
        }

        .login-container p {
            color: #52796f;
            font-size: 14px;
            margin-bottom: 1.5rem;
        }

        /* ==== Input group ==== */
        .input-group {
            text-align: left;
            margin-bottom: 1rem;
        }

        .input-group label {
            display: block;
            font-weight: 600;
            color: #1a535c;
            margin-bottom: 0.4rem;
            font-size: 14px;
        }

        .input-group input {
            width: 100%;
            padding: 10px 12px;
            border: 1px solid #dcdcdc;
            border-radius: 8px;
            outline: none;
            transition: border-color 0.3s ease;
            font-size: 15px;
        }

        .input-group input:focus {
            border-color: #1e6091;
        }

        /* ==== Botón ==== */
        .btn {
            background: linear-gradient(135deg, #1e6091, #52b788);
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 12px 16px;
            width: 100%;
            font-weight: 600;
            font-size: 16px;
            cursor: pointer;
            transition: background 0.3s, transform 0.2s;
        }

        .btn:hover {
            background: linear-gradient(135deg, #168aad, #76c893);
            transform: scale(1.02);
        }

        /* ==== Checkbox y texto ==== */
        .options {
            margin-top: 1rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            font-size: 13px;
            color: #555;
        }

        .options a {
            text-decoration: none;
            color: #168aad;
            font-weight: 500;
        }

        .options a:hover {
            text-decoration: underline;
        }

        /* ==== Errores ==== */
        .alert {
            background: #ffe0e0;
            border: 1px solid #ffb3b3;
            color: #b00000;
            padding: 10px;
            border-radius: 6px;
            font-size: 14px;
            margin-bottom: 1rem;
            text-align: left;
        }

        /* ==== Footer ==== */
        .footer {
            position: absolute;
            bottom: 10px;
            font-size: 13px;
            color: #fff;
            opacity: 0.8;
        }
    </style>
</head>
<body>

    <div class="login-container">
        <h2>Yaca Aventura</h2>
        <p>Explora el mundo con nosotros 🌎</p>

        <?php if($errors->any()): ?>
            <div class="alert">
                <?php echo e($errors->first()); ?>

            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('login.post')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <div class="input-group">
                <label for="email">Correo electrónico</label>
                <input type="email" name="email" placeholder="ejemplo@correo.com" value="<?php echo e(old('email')); ?>" required autofocus>
            </div>

            <div class="input-group">
                <label for="password">Contraseña</label>
                <input type="password" name="password" placeholder="********" required>
            </div>

            <div class="options">
                <label>
                    <input type="checkbox" name="remember"> Recordarme
                </label>
                <a href="#">¿Olvidaste tu contraseña?</a>
            </div>

            <button type="submit" class="btn">Iniciar sesión</button>
        </form>
    </div>

    <div class="footer">
        © <?php echo e(date('Y')); ?> Yaca Aventura — Todos los derechos reservados.
    </div>

</body>
</html>
<?php /**PATH E:\PROJECTS AND COURSES\RICARDO - YACA AVENTURA\yaca_adventure\resources\views/auth/login.blade.php ENDPATH**/ ?>