

<?php $__env->startSection('title', 'Platos del Restaurante'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">

    <!-- Encabezado -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold mb-1">
            <i class="bi bi-egg-fried me-2 text-warning"></i> Platos del Restaurante
            <span class="ms-3 text-muted" id="countInfo"></span>
        </h2>
        <div>
            <button id="exportPdf" class="btn btn-outline-danger me-2">
                <i class="bi bi-filetype-pdf"></i> PDF
            </button>
            <button id="exportExcel" class="btn btn-outline-success me-2">
                <i class="bi bi-file-earmark-excel"></i> Excel
            </button>
            <button id="btnAddDish" class="btn btn-success">
                <i class="bi bi-plus-circle me-1"></i> Agregar Plato
            </button>
        </div>
    </div>

    <!-- Buscador -->
    <form id="searchForm" class="mb-3">
        <div class="input-group w-50">
            <input type="text" id="searchInput" class="form-control" placeholder="Buscar plato...">
            <button type="submit" class="btn btn-primary"><i class="bi bi-search"></i></button>
        </div>
    </form>

    <!-- Tabla -->
    <div class="card shadow-sm">
        <div class="card-body table-responsive">
            <table class="table table-hover align-middle mb-0" id="dishTable">
                <thead class="table-dark">
                    <tr>
                        <th>Imagen</th>
                        <th>Título</th>
                        <th>Precio (S/)</th>
                        <th class="text-center">Acciones</th>
                    </tr>
                </thead>
                <tbody id="dishBody">
                    <tr><td colspan="5" class="text-center text-muted">Cargando...</td></tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Paginación -->
    <div class="d-flex justify-content-center mt-3" id="paginationContainer">
        <button id="prevPage" class="btn btn-outline-primary btn-sm me-2">Anterior</button>
        <span id="paginationInfo"></span>
        <button id="nextPage" class="btn btn-outline-primary btn-sm ms-2">Siguiente</button>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="dishModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div class="modal-content">
            <form id="dishForm" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <input type="hidden" id="dishId">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title" id="modalTitle"><i class="bi bi-plus-circle me-2"></i>Registrar Plato</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-12">
                            <label>Título</label>
                            <input type="text" id="title" name="title" class="form-control" required>
                        </div>
                        <div class="col-md-12">
                            <label>Precio (S/)</label>
                            <input type="number" id="price" name="price" step="0.01" class="form-control" required>
                        </div>
                        <div class="col-md-12">
                            <label>Imagen</label>
                            <input type="file" id="image" name="image" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-success" id="btnSave">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
$(document).ready(function() {
    const modal = new bootstrap.Modal(document.getElementById('dishModal'));
    let currentPage = 1, lastPage = 1, search = '';

    // 🔹 Cargar lista
    loadDishes();

    // 🔹 Buscar
    $('#searchForm').submit(function(e) {
        e.preventDefault();
        search = $('#searchInput').val();
        currentPage = 1;
        loadDishes();
    });

    // 🔹 Paginación
    $('#prevPage').click(() => { if (currentPage > 1) { currentPage--; loadDishes(); } });
    $('#nextPage').click(() => { if (currentPage < lastPage) { currentPage++; loadDishes(); } });

    // 🔹 Mostrar modal agregar
    $('#btnAddDish').click(() => {
        $('#dishForm')[0].reset();
        $('#dishId').val('');
        $('#modalTitle').html('<i class="bi bi-plus-circle me-2"></i>Registrar Plato');
        modal.show();
    });

    // 🔹 Guardar / actualizar
    $('#dishForm').submit(function(e) {
        e.preventDefault();

        let id = $('#dishId').val();
        let formData = new FormData(this);
        if (id) formData.append('_method', 'PUT');

        $.ajax({
            url: id ? `/admin/restaurant-dishes/${id}` : `<?php echo e(route('admin.restaurant-dishes.store')); ?>`,
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function() {
                modal.hide();
                loadDishes();
            },
            error: function(xhr) {
                console.error(xhr.responseText);
                Swal.fire('Error', 'No se pudo guardar el plato.', 'error');
            }
        });
    });

    // 🔹 Cargar platos
    function loadDishes() {
        $('#dishBody').html('<tr><td colspan="5" class="text-center text-muted py-3"><i class="fa fa-spinner fa-spin"></i> Cargando...</td></tr>');
        $.ajax({
            url: `/admin/restaurant-dishes?page=${currentPage}&search=${search}`,
            method: 'GET',
            success: function(res) {
                renderTable(res.data);
                $('#countInfo').text('Total: ' + res.total);
                $('#paginationInfo').text(`Página ${res.current_page} de ${res.last_page}`);
                currentPage = res.current_page;
                lastPage = res.last_page;
            },
            error: function() {
                $('#dishBody').html('<tr><td colspan="5" class="text-center text-danger">Error al cargar platos</td></tr>');
            }
        });
    }

    // 🔹 Renderizar tabla
    function renderTable(dishes) {
        let html = '';
        if (dishes.length === 0) {
            html = '<tr><td colspan="5" class="text-center text-muted py-3">Sin platos registrados</td></tr>';
        } else {
            $.each(dishes, function(i, d) {
                html += `
                    <tr>
                        <td><img src="/img/restaurant-dishes/${d.image}" style="max-width:70px"></td>
                        <td>${d.title}</td>
                        <td>S/ ${parseFloat(d.price).toFixed(2)}</td>
                        <td class="text-center">
                            <button class="btn btn-sm btn-outline-primary m-1" onclick="editDish(${d.id})"><i class="bi bi-pencil-square"></i></button>
                            <button class="btn btn-sm btn-outline-danger m-1" onclick="deleteDish(${d.id})"><i class="bi bi-trash"></i></button>
                        </td>
                    </tr>
                `;
            });
        }
        $('#dishBody').html(html);
    }

    // 🔹 Editar plato
    window.editDish = function(id) {
        $.get(`/admin/restaurant-dishes/${id}`, function(data) {
            $('#dishId').val(data.id);
            $('#title').val(data.title);
            $('#price').val(data.price);
            $('#modalTitle').html('<i class="bi bi-pencil-square me-2"></i>Editar Plato');
            modal.show();
        });
    }

    // 🔹 Eliminar plato
    window.deleteDish = function(id) {
        Swal.fire({
            title: '¿Eliminar este plato?',
            text: 'Esta acción no se puede revertir',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar'
        }).then(result => {
            if (result.isConfirmed) {
                $.ajax({
                    url: `/admin/restaurant-dishes/${id}`,
                    method: 'DELETE',
                    data: { _token: '<?php echo e(csrf_token()); ?>' },
                    success: function() {
                        loadDishes();
                    },
                    error: function() {
                        Swal.fire('Error', 'No se pudo eliminar el plato', 'error');
                    }
                });
            }
        });
    }

    // 🔹 Exportar PDF / Excel
    $('#exportPdf').click(() => window.open(`/admin/restaurant-dishes/export-pdf?search=${search}`, '_blank'));
    $('#exportExcel').click(() => window.location.href = `/admin/restaurant-dishes/export-excel?search=${search}`);
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\PROJECTS AND COURSES\RICARDO - YACA AVENTURA\yaca_adventure\resources\views/admin/dishes/index.blade.php ENDPATH**/ ?>