

<?php $__env->startSection('title', 'Actividades'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">

    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold mb-1">
            <i class="bi bi-sun me-2 text-primary"></i> Actividades
            <span class="ms-3 text-muted" id="countInfo"></span>
        </h2>
        <div>
            <button id="exportPdf" class="btn btn-outline-danger me-2">
                <i class="bi bi-filetype-pdf"></i> PDF
            </button>
            <button id="exportExcel" class="btn btn-outline-success me-2">
                <i class="bi bi-file-earmark-excel"></i> Excel
            </button>
            <button id="btnAddActivity" class="btn btn-success">
                <i class="bi bi-plus-circle me-1"></i> Agregar
            </button>
        </div>
    </div>

    <!-- Buscador -->
    <form id="searchForm" class="mb-3">
        <div class="input-group w-50">
            <input type="text" id="searchInput" class="form-control" placeholder="Buscar actividad...">
            <button type="submit" class="btn btn-primary"><i class="bi bi-search"></i></button>
        </div>
    </form>

    <!-- Tabla -->
    <div class="card shadow-sm">
        <div class="card-body table-responsive">
            <table class="table table-hover align-middle mb-0" id="activityTable">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Imagen</th>
                        <th>Título</th>
                        <th>Descripción</th>
                        <th>Duración</th>
                        <th>Estación</th>
                        <th>Dificultad</th>
                        <th>Ubicación</th>
                        <th>Itinenario</th>
                        <th>Incluye</th>
                        <th>No incluye</th>
                        <th>Precio</th>
                        <th>Personas</th>
                        <th class="text-center">Acciones</th>
                    </tr>
                </thead>
                <tbody id="activityBody">
                    <tr><td colspan="9" class="text-center text-muted">Cargando...</td></tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Paginación -->
    <div class="d-flex justify-content-center mt-3" id="paginationContainer">
        <button id="prevPage" class="btn btn-outline-primary btn-sm me-2">Anterior</button>
        <span id="paginationInfo"></span>
        <button id="nextPage" class="btn btn-outline-primary btn-sm ms-2">Siguiente</button>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="activityModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <form id="activityForm" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <input type="hidden" id="activityId">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title" id="modalTitle"><i class="bi bi-plus-circle me-2"></i>Registrar Actividad</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-12">
                            <label>Título</label>
                            <input type="text" id="title" name="title" class="form-control" required>
                        </div>
                        <div class="col-md-12">
                            <label>Descripción</label>
                            <textarea class="form-control" id="description" name="description" rows="5"></textarea>
                        </div>
                        <div class="col-md-6">
                            <label>Duración / Horarios</label>
                            <textarea class="form-control" id="duration" name="duration" rows="5"></textarea>
                        </div>
                        <div class="col-md-6">
                            <label>Estación</label>
                            <input type="text" id="season" name="season" class="form-control">
                        </div>
                        <div class="col-md-6">
                            <label>Dificultad</label>
                            <input type="text" id="difficulty_level" name="difficulty_level" class="form-control">
                        </div>
                        <div class="col-md-6">
                            <label>Ubicación</label>
                            <input type="text" id="location" name="location" class="form-control">
                        </div>
                        <div class="col-md-12">
                            <label>Itinenario</label>
                            <textarea class="form-control" id="itinerary" name="itinerary" rows="5"></textarea>
                        </div>
                        <div class="col-md-12">
                            <label>Incluye</label>
                            <textarea class="form-control" id="includes" name="includes" rows="5"></textarea>
                        </div>
                        <div class="col-md-12">
                            <label>No incluye</label>
                            <textarea class="form-control" id="not_includes" name="not_includes" rows="5"></textarea>
                        </div>
                        <div class="col-md-6">
                            <label>Precio</label>
                            <input type="number" id="price" name="price" class="form-control" step="0.01">
                        </div>
                        <div class="col-md-6">
                            <label>Personas</label>
                            <input type="number" id="people_count" name="people_count" class="form-control">
                        </div>
                        <div class="col-md-12">
                            <label>Imagen</label>
                            <input type="file" id="image" name="image" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-success" id="btnSave">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
$(document).ready(function() {
    const modal = new bootstrap.Modal(document.getElementById('activityModal'));
    let currentPage = 1, lastPage = 1, search = '';

    // 🔹 Cargar lista
    loadActivities();

    // 🔹 Buscar
    $('#searchForm').submit(function(e) {
        e.preventDefault();
        search = $('#searchInput').val();
        currentPage = 1;
        loadActivities();
    });

    // 🔹 Paginación
    $('#prevPage').click(() => { if (currentPage > 1) { currentPage--; loadActivities(); } });
    $('#nextPage').click(() => { if (currentPage < lastPage) { currentPage++; loadActivities(); } });

    // 🔹 Mostrar modal agregar
    $('#btnAddActivity').click(() => {
        $('#activityForm')[0].reset();
        $('#activityId').val('');
        $('#modalTitle').html('<i class="bi bi-plus-circle me-2"></i>Registrar Actividad');
        modal.show();
    });

    // 🔹 Guardar / actualizar
    $('#activityForm').submit(function(e) {
        e.preventDefault();

        let id = $('#activityId').val();
        let formData = new FormData(this);
        if (id) formData.append('_method', 'PUT');

        $.ajax({
            url: id ? `/admin/activities/${id}` : `<?php echo e(route('admin.activities.store')); ?>`,
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function() {
                modal.hide();
                loadActivities();
            },
            error: function(xhr) {
                console.error(xhr.responseText);
                Swal.fire('Error', 'No se pudo guardar la actividad.', 'error');
            }
        });
    });

    // 🔹 Cargar actividades
    function loadActivities() {
        $('#activityBody').html('<tr><td colspan="9" class="text-center text-muted py-3"><i class="fa fa-spinner fa-spin"></i> Cargando...</td></tr>');
        $.ajax({
            url: `/admin/activities?page=${currentPage}&search=${search}`,
            method: 'GET',
            success: function(res) {
                renderTable(res.data);
                $('#countInfo').text('Total: ' + res.total);
                $('#paginationInfo').text(`Página ${res.current_page} de ${res.last_page}`);
                currentPage = res.current_page;
                lastPage = res.last_page;
            },
            error: function() {
                $('#activityBody').html('<tr><td colspan="9" class="text-center text-danger">Error al cargar actividades</td></tr>');
            }
        });
    }

    // 🔹 Renderizar tabla
    function renderTable(activities) {
        let html = '';
        if (activities.length === 0) {
            html = '<tr><td colspan="9" class="text-center text-muted py-3">Sin actividades</td></tr>';
        } else {
            $.each(activities, function(i, a) {
                let description =  a.description 
                                        ? (a.description.length > 40 
                                            ? a.description.substring(0, 40) + '...' 
                                            : a.description)
                                        : '';

                let itinerary =  a.itinerary 
                                        ? (a.itinerary.length > 40 
                                            ? a.itinerary.substring(0, 40) + '...' 
                                            : a.itinerary)
                                        : '';

                let includes =  a.includes 
                                        ? (a.includes.length > 40 
                                            ? a.includes.substring(0, 40) + '...' 
                                            : a.includes)
                                        : '';

                let duration =  a.duration 
                                        ? (a.duration.length > 40 
                                            ? a.duration.substring(0, 40) + '...' 
                                            : a.duration)
                                        : '';

                html += `
                    <tr>
                        <td>${i + 1}</td>
                        <td><img src="/img/activities/${a.image}" style="max-width:70px"></td>
                        <td>${a.title}</td>
                        <td>${description}</td>
                        <td>${duration}</td>
                        <td>${a.season ?? '-'}</td>
                        <td>${a.difficulty_level ?? '-'}</td>
                        <td>${a.location}</td>
                        <td>${itinerary}</td>
                        <td>${includes}</td>
                        <td>${a.not_includes}</td>
                        <td>${parseFloat(a.price).toFixed(2)}</td>
                        <td>${a.people_count}</td>
                        <td class="text-center">
                            <button class="btn btn-sm btn-outline-primary m-1" onclick="editActivity(${a.id})"><i class="bi bi-pencil-square"></i></button>
                            <button class="btn btn-sm btn-outline-danger m-1" onclick="deleteActivity(${a.id})"><i class="bi bi-trash"></i></button>
                        </td>
                    </tr>
                `;
            });
        }
        $('#activityBody').html(html);
    }

    // 🔹 Editar actividad
    window.editActivity = function(id) {
        $.get(`/admin/activities/${id}`, function(data) {
            $('#activityId').val(data.id);
            $('#title').val(data.title);
            $('#description').val(data.description);
            $('#duration').val(data.duration);
            $('#season').val(data.season);
            $('#difficulty_level').val(data.difficulty_level);
            $('#location').val(data.location);
            $('#itinerary').val(data.itinerary);
            $('#includes').val(data.includes);
            $('#not_includes').val(data.not_includes);
            $('#price').val(data.price);
            $('#people_count').val(data.people_count);
            $('#modalTitle').html('<i class="bi bi-pencil-square me-2"></i>Editar Actividad');
            modal.show();
        });
    }

    // 🔹 Eliminar actividad
    window.deleteActivity = function(id) {
        Swal.fire({
            title: '¿Eliminar esta actividad?',
            text: 'Esta acción no se puede revertir',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar'
        }).then(result => {
            if (result.isConfirmed) {
                $.ajax({
                    url: `/admin/activities/${id}`,
                    method: 'DELETE',
                    data: { _token: '<?php echo e(csrf_token()); ?>' },
                    success: function() {
                        loadActivities();
                    },
                    error: function() {
                        Swal.fire('Error', 'No se pudo eliminar la actividad', 'error');
                    }
                });
            }
        });
    }

    // 🔹 Exportar PDF / Excel
    $('#exportPdf').click(() => window.open(`/admin/activities/export-pdf?search=${search}`, '_blank'));
    $('#exportExcel').click(() => window.location.href = `/admin/activities/export-excel?search=${search}`);
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\PROJECTS AND COURSES\RICARDO - YACA AVENTURA\yaca_adventure\resources\views/admin/activities/index.blade.php ENDPATH**/ ?>