<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PublicController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\{ UserController, AuthController, RestaurantController, RestaurantDishController };
use App\Http\Controllers\Admin\ActivityController;

Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.post');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Sitio público
Route::controller(PublicController::class)->group(function () {
    Route::get('/', 'home')->name('public.home');
    Route::get('/adventure', 'adventure')->name('public.adventure');
    Route::get('/blog', 'blog')->name('public.blog');
    Route::get('/store', 'store')->name('public.store');
});


Route::get('/activities', [ActivityController::class, 'indexPublic'])->name('public.activities');
Route::get('/public/activities', [ActivityController::class, 'listPublic'])->name('public.activities');
Route::get('/activities/{id}', [ActivityController::class, 'showPublic']);

Route::get('/restaurants', [RestaurantController::class, 'index']);

Route::prefix('admin')->name('admin.')->group(function () {
    Route::get('/users', [UserController::class, 'index'])->name('users.index');
    Route::post('/users', [UserController::class, 'store'])->name('users.store');
    Route::put('/users/{user}', [UserController::class, 'update'])->name('users.update');
    Route::delete('/users/{user}', [UserController::class, 'destroy'])->name('users.destroy');
});

Route::prefix('admin')->name('admin.')->group(function () {
    Route::get('activities', [ActivityController::class, 'index'])->name('activities.index');
    Route::get('activities/{id}', [ActivityController::class, 'show'])->name('activities.show');
    Route::post('activities', [ActivityController::class, 'store'])->name('activities.store');
    Route::put('activities/{id}', [ActivityController::class, 'update'])->name('activities.update');
    Route::delete('activities/{id}', [ActivityController::class, 'destroy'])->name('activities.destroy');

    // Exportaciones (opcional)
    Route::get('activities/export-pdf', [ActivityController::class, 'exportPdf']);
    Route::get('activities/export-excel', [ActivityController::class, 'exportExcel']);
});

// --- Módulo de Platos ---
Route::prefix('admin')->name('admin.')->group(function () {
    Route::get('restaurant-dishes', [RestaurantDishController::class, 'index'])->name('restaurant-dishes.index');
    Route::get('restaurant-dishes/{id}', [RestaurantDishController::class, 'show'])->name('restaurant-dishes.show');
    Route::post('restaurant-dishes', [RestaurantDishController::class, 'store'])->name('restaurant-dishes.store');
    Route::put('restaurant-dishes/{id}', [RestaurantDishController::class, 'update'])->name('restaurant-dishes.update');
    Route::delete('restaurant-dishes/{id}', [RestaurantDishController::class, 'destroy'])->name('restaurant-dishes.destroy');

    // Exportaciones (opcional)
    Route::get('restaurant-dishes/export-pdf', [RestaurantDishController::class, 'exportPdf']);
    Route::get('restaurant-dishes/export-excel', [RestaurantDishController::class, 'exportExcel']);
});
