@extends('layouts.public')
@section('title', 'Restaurante – Yaca Adventure')
@section('content')

<main class="main">

  <!-- Encabezado con imagen y capa oscura -->
  <div class="page-title position-relative text-white"
       style="background-image: url('/img/restaurants/{{ $restaurant->image }}');
              background-size: cover;
              background-position: center;
              height: 420px;
              display: flex;
              align-items: center;
              justify-content: center;
              overflow: hidden;">
              
    <div class="position-absolute top-0 start-0 w-100 h-100" 
         style="background: rgba(0, 0, 0, 0.65);"></div>

    <div class="container position-relative text-center px-4">
      <h1 class="fw-bold display-5 text-white text-shadow mb-3">
        {{ $restaurant->title ?? 'Restaurante Yaca Adventure' }}
      </h1>
      <p class="fs-5 text-light mx-auto" style="max-width: 800px;">
        {{ $restaurant->description ?? 'Disfruta de una experiencia gastronómica inolvidable rodeado de naturaleza.' }}
      </p>
    </div>
  </div>

  <!-- Sección principal -->
  <section class="py-5" style="background: #f9fafb;">
        <div class="container">

            <div class="text-center mb-5">
                <h2 class="fw-bold text-success">Nuestra Experiencia Gastronómica</h2>
                <div class="divider mx-auto my-3"
                     style="width: 80px; height: 3px; background-color: #198754; border-radius: 10px;"></div>
                <p class="text-muted fs-5 mx-auto" style="max-width: 700px;">
                  Vive la fusión perfecta entre sabor, naturaleza y hospitalidad. 
                  Cada plato está inspirado en la cultura local y preparado con ingredientes frescos de la región.
                </p>
            </div>

            <div class="row g-4 align-items-center">

                <!-- Imagen lateral -->
                <div class="col-lg-6">
                  <div class="rounded shadow-sm overflow-hidden">
                    <img src="/img/restaurants/{{ $restaurant->image }}" 
                         alt="Experiencia gastronómica"
                         class="img-fluid w-100"
                         style="object-fit: cover; height: 360px;">
                  </div>
                </div>

                <!-- Texto lateral -->
                <div class="col-lg-6">
                  <h3 class="fw-bold mb-3 text-success">Ambiente y Experiencia</h3>
                  <p class="text-muted mb-4 lh-lg">
                    {!! nl2br(e($restaurant->environment_experience)) !!}
                  </p>
                </div>
            </div>

              <!-- Información de ubicación y horario -->
              <div class="row mt-5 text-center gy-4">
                <div class="col-md-6">
                  <div class="card border-0 shadow-sm h-100 p-4 hover-lift">
                    <i class="bi bi-geo-alt-fill fs-1 text-success mb-3"></i>
                    <h5 class="fw-bold mb-2">Ubicación</h5>
                    <p class="text-muted mb-0">
                      {{ $restaurant->location }}
                    </p>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="card border-0 shadow-sm h-100 p-4 hover-lift">
                    <i class="bi bi-clock-fill fs-1 text-success mb-3"></i>
                    <h5 class="fw-bold mb-2">Horario de Atención</h5>
                    <p class="text-muted mb-0">
                      {{ $restaurant->hours }}
                    </p>
                  </div>
                </div>
              </div>

              <!-- CTA de reserva -->
            <div class="text-center m-4">
                <a href="https://wa.me/51948717625?text=Hola!%20Quisiera%20hacer%20una%20reserva%20en%20el%20Restaurante%20Yaca%20Adventure%20🍽️"
                   target="_blank"
                   class="btn btn-success btn-lg rounded-pill px-5 py-3 shadow-sm">
                    <i class="bi bi-whatsapp me-2"></i> Reservar ahora por WhatsApp
                </a>
            </div>
        </div>

        @if($dishes->count() > 0)
            <section class="py-5 bg-light">
                <div class="container">
                    <!-- Título -->
                    <div class="text-center mb-5">
                        <h2 class="fw-bold text-success text-uppercase">Nuestros Platos</h2>
                        <div class="mx-auto my-3" 
                             style="width: 80px; height: 4px; background-color: #198754; border-radius: 5px;"></div>
                        <p class="text-muted">Descubre nuestros deliciosos platos preparados con ingredientes frescos y el mejor sabor de la casa.</p>
                    </div>

                    <!-- Platos -->
                    <div class="row g-4">
                        @foreach($dishes as $dish)
                            <div class="col-md-4 col-sm-6">
                                <div class="card h-100 border-0 shadow-sm rounded-4 overflow-hidden dish-card">
                                    <div class="position-relative">
                                        <img src="/img/restaurant-dishes/{{ $dish->image }}" 
                                             class="card-img-top" 
                                             alt="{{ $dish->title }}"
                                             style="height: 240px; object-fit: cover;">
                                        <div class="overlay position-absolute top-0 start-0 w-100 h-100"
                                             style="background: rgba(0,0,0,0.2); transition: background 0.3s;"></div>
                                    </div>

                                    <div class="card-body text-center">
                                        <h5 class="fw-bold text-dark mb-2">{{ $dish->title }}</h5>
                                        <p class="text-success fw-semibold fs-5 mb-3">S/ {{ number_format($dish->price, 2) }}</p>

                                        <!-- Botón WhatsApp -->
                                        <a href="https://wa.me/51948717625?text=Hola!%20Quisiera%20consultar%20sobre%20el%20plato%20{{ urlencode($dish->title) }}"
                                           target="_blank"
                                           class="btn btn-success px-4 rounded-pill shadow-sm d-inline-flex align-items-center gap-2">
                                            <i class="bi bi-whatsapp fs-5"></i>
                                            Consultar Plato
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </section>

            <!-- Estilos adicionales -->
            <style>
                .dish-card:hover .overlay {
                    background: rgba(0,0,0,0.5);
                }
                .dish-card:hover img {
                    transform: scale(1.05);
                    transition: transform 0.5s;
                }
                .dish-card img {
                    transition: transform 0.5s;
                }
            </style>
        @endif
    </section>

</main>

<style>
  .text-shadow {
    text-shadow: 0 2px 8px rgba(0,0,0,0.8);
  }
  .hover-lift {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
  }
  .hover-lift:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.1);
  }
</style>

@endsection
