@extends('layouts.public')

@section('title', 'Inicio')

@section('content')
<main class="main">

    <!-- Travel Hero Section -->
    <section id="travel-hero" class="travel-hero section dark-background">

      <div class="container">

        <div class="row align-items-center">
          <div class="col-lg-6">
            <div class="content">
              <h1>Aventura sin límites con YACA AVENTURA</h1>
              <p class="lead">Donde la aventura se encuentra con la cultura andina.</p>
              <div class="d-flex flex-wrap gap-3 mt-4">
                <a href="destinations.html" class="btn btn-primary">Start Exploring</a>
                <a href="tours.html" class="btn btn-outline-light">View Tours</a>
              </div>
            </div>
          </div>
          <div class="col-lg-6 mt-5 mt-lg-0">
            <div class="booking-form">
              <form action="" method="post">
                <div class="row gy-3">
                  <div class="col-md-12">
                    <label for="destination">Destination</label>
                    <input type="text" name="destination" id="destination" class="form-control" placeholder="Where do you want to go?" required="">
                  </div>
                  <div class="col-md-6">
                    <label for="check-in">Check In</label>
                    <input type="date" name="checkin" id="check-in" class="form-control" required="">
                  </div>
                  <div class="col-md-6">
                    <label for="check-out">Check Out</label>
                    <input type="date" name="checkout" id="check-out" class="form-control" required="">
                  </div>
                  <div class="col-md-6">
                    <label for="adults">Adults</label>
                    <input type="number" name="adults" id="adults" class="form-control" min="1" max="20" value="2" required="">
                  </div>
                  <div class="col-md-6">
                    <label for="children">Children</label>
                    <input type="number" name="children" id="children" class="form-control" min="0" max="20" value="0">
                  </div>
                  <div class="col-md-12 text-center">
                    <button type="submit" class="btn btn-accent w-100 mt-3">Search Tours</button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>

      </div>

    </section><!-- /Travel Hero Section -->

    <!-- Why Us Section -->
    <section id="why-us" class="why-us section" style="padding: 60px 0px 10px 0px;">

      <div class="container">

        <!-- Main Content Grid -->
        <div class="content-grid">
          <div class="row g-4 align-items-stretch">

            <!-- About Section -->
            <div class="col-lg-6">
                <div class="about-block">
                    <div class="about-header">
                        <span class="section-badge">Sobre nosotros</span>
                        <h3>🌄 Nosotros – Yaca Adventure</h3>
                    </div>
                    <div class="about-content">
                        <b>Historia y valores</b>
                        <p>Yaca Adventure nace en el corazón de Apurímac, tierra de montañas, ríos y cultura milenaria. Fundada con el propósito de conectar a las personas con la naturaleza y las tradiciones andinas, nuestra empresa busca ofrecer experiencias únicas que combinan aventura, cultura y hospitalidad.</p>

                        <div class="feature-list">
                            <div class="feature-item">
                              <i class="bi bi-check-circle-fill"></i>
                              <span>Guías locales expertos en cada destino</span>
                            </div>
                            <div class="feature-item">
                              <i class="bi bi-check-circle-fill"></i>
                              <span>Itinerarios personalizados para cada viajero</span>
                            </div>
                            <div class="feature-item">
                              <i class="bi bi-check-circle-fill"></i>
                              <span>Atención al cliente 24/7 durante todo tu viaje</span>
                            </div>
                            <div class="feature-item">
                                <button class="btn btn-success">Ver más...</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Image Showcase -->
            <div class="col-lg-6">
              <div class="image-showcase">
                <div class="main-image">
                  <img src="assets/img/travel/showcase-12.webp" alt="Travel Adventure" class="img-fluid rounded-3">
                </div>
              </div>
            </div>

          </div>
        </div><!-- End Main Content Grid -->
      </div>

    </section><!-- /Why Us Section -->

    <!-- Featured Destinations Section -->
    <section id="featured-destinations" class="featured-destinations section" style="padding: 20px 0;">
        <div class="container section-title">
            <h2>Actividades destacadas</h2>
            <div><span>Te mostramos nuestras actividades</span></div>
        </div>

        <div class="container">
            <div class="row gy-4" id="activitiesContainer">
                <!-- 🔹 Aquí jQuery insertará las tarjetas -->
            </div>

            <div class="destinations-cta mt-4">
                <div class="row justify-content-center">
                    <div class="col-lg-8 text-center">
                        <h3>¿No sabes qué actividad elegir?</h3>
                        <p>Nuestros expertos te ayudarán a encontrar la experiencia perfecta.</p>
                        <div class="cta-buttons">
                            <a href="/activities" class="btn btn-primary">Ver todas las actividades</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Featured Destinations Section -->
    <section id="featured-destinations" class="featured-destinations section" style="padding: 20px 0;">
        <div class="container section-title">
            <h2>Nuestro restaurante</h2>
            <div><span>Te mostramos nuestros platos</span></div>
        </div>

        <div class="container">
            <div class="row gy-4" id="restauranteContainer">
                <!-- 🔹 Aquí jQuery insertará las tarjetas -->
            </div>

            <div class="destinations-cta mt-4">
                <div class="row justify-content-center">
                    <div class="col-lg-8 text-center">
                        <h3>¿No sabes qué platillos elegir?</h3>
                        <p>Nuestros expertos te ayudarán a encontrar el que mas pueda degustar.</p>
                        <div class="cta-buttons">
                            <a href="/activities" class="btn btn-primary">Ver el restaurante</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Featured Destinations Section -->
    <section id="featured-destinations" class="featured-destinations section" style="padding: 20px 0;">
        <div class="container section-title">
            <h2>Nuestra tienda</h2>
            <div><span>Te mostramos los productos que tenemos para ti</span></div>
        </div>

        <div class="container">
            <div class="row gy-4" id="storeContainer">
                <!-- 🔹 Aquí jQuery insertará las tarjetas -->
            </div>

            <div class="destinations-cta mt-4">
                <div class="row justify-content-center">
                    <div class="col-lg-8 text-center">
                        <h3>¿No sabes qué productos elegir?</h3>
                        <p>Nuestros expertos te ayudarán a encontrar el producto que mas le guste.</p>
                        <div class="cta-buttons">
                            <a href="/activities" class="btn btn-primary">Ver tienda</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonials Home Section -->
    <section id="testimonials-home" class="testimonials-home section">

      <!-- Section Title -->
      <div class="container section-title">
        <h2>Testimonios</h2>
        <div><span>Lo que nuestras clientes</span> <span class="description-title">están diciendo</span></div>
      </div><!-- End Section Title -->

      <div class="container">

        <div class="swiper init-swiper">
          <script type="application/json" class="swiper-config">
            {
              "loop": true,
              "speed": 600,
              "autoplay": {
                "delay": 5000
              },
              "slidesPerView": "auto",
              "pagination": {
                "el": ".swiper-pagination",
                "type": "bullets",
                "clickable": true
              }
            }
          </script>
          <div class="swiper-wrapper">

            <div class="swiper-slide">
              <div class="testimonial-item">
                <div class="row gy-4 justify-content-center">
                  <div class="col-lg-6">
                    <div class="testimonial-content">
                      <p>
                        <i class="bi bi-quote quote-icon-left"></i>
                        <span>Proin iaculis purus consequat sem cure digni ssim donec porttitora entum suscipit rhoncus. Accusantium quam, ultricies eget id, aliquam eget nibh et. Maecen aliquam, risus at semper.</span>
                        <i class="bi bi-quote quote-icon-right"></i>
                      </p>
                      <h3>Saul Goodman</h3>
                      <h4>Ceo &amp; Founder</h4>
                      <div class="stars">
                        <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-2 text-center">
                    <img src="assets/img/person/person-m-9.webp" class="img-fluid testimonial-img" alt="">
                  </div>
                </div>
              </div>
            </div><!-- End testimonial item -->

            <div class="swiper-slide">
              <div class="testimonial-item">
                <div class="row gy-4 justify-content-center">
                  <div class="col-lg-6">
                    <div class="testimonial-content">
                      <p>
                        <i class="bi bi-quote quote-icon-left"></i>
                        <span>Export tempor illum tamen malis malis eram quae irure esse labore quem cillum quid cillum eram malis quorum velit fore eram velit sunt aliqua noster fugiat irure amet legam anim culpa.</span>
                        <i class="bi bi-quote quote-icon-right"></i>
                      </p>
                      <h3>Sara Wilsson</h3>
                      <h4>Designer</h4>
                      <div class="stars">
                        <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-2 text-center">
                    <img src="assets/img/person/person-f-5.webp" class="img-fluid testimonial-img" alt="">
                  </div>
                </div>
              </div>
            </div><!-- End testimonial item -->

            <div class="swiper-slide">
              <div class="testimonial-item">
                <div class="row gy-4 justify-content-center">
                  <div class="col-lg-6">
                    <div class="testimonial-content">
                      <p>
                        <i class="bi bi-quote quote-icon-left"></i>
                        <span>Enim nisi quem export duis labore cillum quae magna enim sint quorum nulla quem veniam duis minim tempor labore quem eram duis noster aute amet eram fore quis sint minim.</span>
                        <i class="bi bi-quote quote-icon-right"></i>
                      </p>
                      <h3>Jena Karlis</h3>
                      <h4>Store Owner</h4>
                      <div class="stars">
                        <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-2 text-center">
                    <img src="assets/img/person/person-f-12.webp" class="img-fluid testimonial-img" alt="">
                  </div>
                </div>
              </div>
            </div><!-- End testimonial item -->

            <div class="swiper-slide">
              <div class="testimonial-item">
                <div class="row gy-4 justify-content-center">
                  <div class="col-lg-6">
                    <div class="testimonial-content">
                      <p>
                        <i class="bi bi-quote quote-icon-left"></i>
                        <span>Fugiat enim eram quae cillum dolore dolor amet nulla culpa multos export minim fugiat minim velit minim dolor enim duis veniam ipsum anim magna sunt elit fore quem dolore labore illum veniam.</span>
                        <i class="bi bi-quote quote-icon-right"></i>
                      </p>
                      <h3>John Larson</h3>
                      <h4>Entrepreneur</h4>
                      <div class="stars">
                        <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-2 text-center">
                    <img src="assets/img/person/person-m-12.webp" class="img-fluid testimonial-img" alt="">
                  </div>
                </div>
              </div>
            </div><!-- End testimonial item -->

          </div>
          <div class="swiper-pagination"></div>
        </div>

      </div>

    </section><!-- /Testimonials Home Section -->
</main>
<script>
$(document).ready(function() {
    $.ajax({
        url: "{{ route('public.activities') }}",
        method: "GET",
        success: function(response) {
            const activities = response.activities;
            const container = $("#activitiesContainer");
            container.empty();

            if (activities.length === 0) {
                container.append(`<div class="col-12 text-center text-muted">No hay actividades disponibles por ahora.</div>`);
                return;
            }

            activities.forEach(a => {
                const shortDesc = a.description.length > 120
                    ? a.description.substring(0, 120) + "..."
                    : a.description;

                const card = `
                    <div class="col-lg-4 col-md-6">
                        <div class="destination-card">
                            <div class="image-wrapper">
                                <img src="/img/activities/${a.image}" alt="${a.title}" class="img-fluid">
                                <div class="overlay">
                                    <div class="badge">Popular</div>
                                </div>
                            </div>
                            <div class="content">
                                <h4>${a.title}</h4>
                                <p>${shortDesc}</p>
                                <div class="features">
                                    <span class="feature-tag">Aventura</span>
                                    <span class="feature-tag">Naturaleza</span>
                                </div>
                                <div class="card-footer d-flex justify-content-between align-items-center">
                                    <div class="tours-count">S/ ${parseFloat(a.price).toFixed(2)}</div>
                                    <a href="/activities/${a.id}" class="explore-btn">
                                        Ver más <i class="bi bi-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                `;

                container.append(card);
            });
        },
        error: function() {
            $("#activitiesContainer").html(`<div class="col-12 text-center text-danger">Error al cargar las actividades.</div>`);
        }
    });

    $.ajax({
        url: "{{ route('public.activities') }}",
        method: "GET",
        success: function(response) {
            const activities = response.activities;
            const container = $("#restauranteContainer");
            container.empty();

            if (activities.length === 0) {
                container.append(`<div class="col-12 text-center text-muted">No hay actividades disponibles por ahora.</div>`);
                return;
            }

            activities.forEach(a => {
                const shortDesc = a.description.length > 120
                    ? a.description.substring(0, 120) + "..."
                    : a.description;

                const card = `
                    <div class="col-lg-4 col-md-6">
                        <div class="destination-card">
                            <div class="image-wrapper">
                                <img src="/img/activities/${a.image}" alt="${a.title}" class="img-fluid">
                                <div class="overlay">
                                    <div class="badge">Popular</div>
                                </div>
                            </div>
                            <div class="content">
                                <h4>${a.title}</h4>
                                <p>${shortDesc}</p>
                                <div class="features">
                                    <span class="feature-tag">Aventura</span>
                                    <span class="feature-tag">Naturaleza</span>
                                </div>
                                <div class="card-footer d-flex justify-content-between align-items-center">
                                    <div class="tours-count">S/ ${parseFloat(a.price).toFixed(2)}</div>
                                    <a href="/activities/${a.id}" class="explore-btn">
                                        Ver más <i class="bi bi-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                `;

                container.append(card);
            });
        },
        error: function() {
            $("#restauranteContainer").html(`<div class="col-12 text-center text-danger">Error al cargar las actividades.</div>`);
        }
    });

    $.ajax({
        url: "{{ route('public.activities') }}",
        method: "GET",
        success: function(response) {
            const activities = response.activities;
            const container = $("#storeContainer");
            container.empty();

            if (activities.length === 0) {
                container.append(`<div class="col-12 text-center text-muted">No hay actividades disponibles por ahora.</div>`);
                return;
            }

            activities.forEach(a => {
                const shortDesc = a.description.length > 120
                    ? a.description.substring(0, 120) + "..."
                    : a.description;

                const card = `
                    <div class="col-lg-4 col-md-6">
                        <div class="destination-card">
                            <div class="image-wrapper">
                                <img src="/img/activities/${a.image}" alt="${a.title}" class="img-fluid">
                                <div class="overlay">
                                    <div class="badge">Popular</div>
                                </div>
                            </div>
                            <div class="content">
                                <h4>${a.title}</h4>
                                <p>${shortDesc}</p>
                                <div class="features">
                                    <span class="feature-tag">Aventura</span>
                                    <span class="feature-tag">Naturaleza</span>
                                </div>
                                <div class="card-footer d-flex justify-content-between align-items-center">
                                    <div class="tours-count">S/ ${parseFloat(a.price).toFixed(2)}</div>
                                    <a href="/activities/${a.id}" class="explore-btn">
                                        Ver más <i class="bi bi-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                `;

                container.append(card);
            });
        },
        error: function() {
            $("#storeContainer").html(`<div class="col-12 text-center text-danger">Error al cargar las actividades.</div>`);
        }
    });
});
</script>
@endsection
