@extends('layouts.public')
@section('title', 'Inicio')
@section('content')
<main class="main">

    <!-- Encabezado con imagen y fondo oscuro -->
    <div class="page-title position-relative text-white" 
         style="background-image: url('/img/activities/{{ $activity->image }}');
                background-size: cover;
                background-position: center;
                height: 400px;
                display: flex;
                align-items: center;
                justify-content: center;
                overflow: hidden;">
      
      <!-- Capa oscura superpuesta -->
      <div class="position-absolute top-0 start-0 w-100 h-100" 
           style="background: rgba(0, 0, 0, 0.65);"></div>

      <!-- Contenido centrado -->
      <div class="container position-relative text-center px-4">
        <h1 class="fw-bold display-5 text-white text-shadow mb-3">
          {{ $activity->title }}
        </h1>
        <p class="fs-5 text-light mx-auto" style="max-width: 800px;">
          {{ Str::limit(strip_tags($activity->description), 150, '...') }}
        </p>
      </div>
    </div>

  <!-- Activity Detail Section -->
<section id="activity-detail" class="activity-detail section py-5" style="background: #f9fafb;">
  <div class="container">

    <!-- Encabezado -->
    <div class="text-center mb-5">
        <h2 class="fw-bold text-success">{{ $activity->title }}</h2>
        <p class="text-muted fs-5 mt-2">
            Vive una experiencia única en 📍 <strong>{{ $activity->location ?? 'nuestro destino destacado' }}</strong>
        </p>
        <div class="divider mx-auto my-3" 
             style="width: 90px; height: 4px; background-color: #198754; border-radius: 10px;"></div>
    </div>

    <div class="row justify-content-center">
      <div class="col-lg-10">

        <!-- Contenedor principal -->
        <div class="card border-0 shadow-lg overflow-hidden rounded-4">
          <div class="row g-0 align-items-center">

            <!-- Imagen -->
            <div class="col-lg-6">
              <img src="/img/activities/{{ $activity->image }}" 
                   alt="{{ $activity->title }}" 
                   class="img-fluid w-100 h-100 object-fit-cover">
            </div>

            <!-- Información principal -->
            <div class="col-lg-6 p-4 p-lg-5">
              <h4 class="fw-bold mb-3 text-success">
                <i class="bi bi-info-circle me-2"></i> Acerca de esta actividad
              </h4>
              <p class="fs-6 text-muted" style="white-space: pre-line;">
                {!! nl2br(e($activity->description)) !!}
              </p>

              <ul class="list-unstyled mt-4 fs-6">
                <li><i class="bi bi-clock text-success me-2"></i><strong>Duración:</strong> {{ $activity->duration ?? 'No especificada' }}</li>
                <li><i class="bi bi-calendar-event text-success me-2"></i><strong>Temporada:</strong> {{ $activity->season ?? 'Todo el año' }}</li>
                <li><i class="bi bi-bar-chart-line text-success me-2"></i><strong>Dificultad:</strong> {{ $activity->difficulty_level ?? 'Moderada' }}</li>
                <li><i class="bi bi-people text-success me-2"></i><strong>Capacidad:</strong> {{ $activity->people_count ?? 'No definida' }} personas</li>
                <li><i class="bi bi-cash-coin text-success me-2"></i><strong>Precio:</strong> S/ {{ number_format($activity->price, 2) }}</li>
              </ul>

              <div class="text-center mt-4">
                <a href="https://wa.me/51948717625?text=¡Hola! 👋 Estoy interesado en la actividad: *{{ urlencode($activity->title) }}* y quisiera más información."
                   target="_blank"
                   class="btn btn-success btn-lg w-100 shadow-sm"
                   style="border-radius: 50px; font-size: 1.05rem;">
                  <i class="bi bi-whatsapp me-2 fs-4"></i> Reservar ahora por WhatsApp
                </a>
              </div>
            </div>

          </div>
        </div>

        <!-- Itinerario -->
        @if(!empty($activity->itinerary))
        <div class="card border-0 shadow-sm mt-5">
          <div class="card-body">
            <h4 class="fw-bold text-primary mb-3"><i class="bi bi-map text-success me-2"></i> Itinerario</h4>
            <p class="fs-6" style="white-space: pre-line;">{!! nl2br(e($activity->itinerary)) !!}</p>
          </div>
        </div>
        @endif

        <!-- Incluye / No incluye -->
        <div class="row mt-4 g-4">
          @if(!empty($activity->includes))
          <div class="col-md-6">
            <div class="card border-0 shadow-sm h-100">
              <div class="card-body">
                <h5 class="fw-bold text-success mb-3"><i class="bi bi-check-circle me-2"></i> Incluye</h5>
                <ul class="list-unstyled fs-6">
                  @foreach(explode("\n", $activity->includes) as $item)
                    @if(trim($item) !== '')
                      <li><i class="bi bi-dot text-success"></i> {{ trim($item) }}</li>
                    @endif
                  @endforeach
                </ul>
              </div>
            </div>
          </div>
          @endif

          @if(!empty($activity->not_includes))
          <div class="col-md-6">
            <div class="card border-0 shadow-sm h-100">
              <div class="card-body">
                <h5 class="fw-bold text-danger mb-3"><i class="bi bi-x-circle me-2"></i> No incluye</h5>
                <ul class="list-unstyled fs-6">
                  @foreach(explode("\n", $activity->not_includes) as $item)
                    @if(trim($item) !== '')
                      <li><i class="bi bi-dot text-danger"></i> {{ trim($item) }}</li>
                    @endif
                  @endforeach
                </ul>
              </div>
            </div>
          </div>
          @endif
        </div>

        <!-- Botón volver -->
        <div class="text-center mt-5">
          <a href="/activities" class="btn btn-outline-secondary px-4 py-2 rounded-pill">
            <i class="bi bi-arrow-left"></i> Volver a actividades
          </a>
        </div>

      </div>
    </div>
  </div>
</section>
</main>
@endsection
