@extends('layouts.public')
@section('title', 'Actividades de Aventura')
@section('content')

<main class="main">
    <!-- Encabezado con imagen y fondo oscuro -->
    <div class="page-title position-relative text-white" 
       style="background-image: url('/img/activities/fondo.jpg');
              background-size: cover;
              background-position: center;
              height: 400px;
              display: flex;
              align-items: center;
              justify-content: center;
              overflow: hidden;">

      <!-- Capa oscura superpuesta -->
      <div class="position-absolute top-0 start-0 w-100 h-100" 
           style="background: rgba(0, 0, 0, 0.65);"></div>

      <!-- Contenido centrado -->
        <div class="container position-relative text-center px-4">
            <h1 class="fw-bold display-5 text-white text-shadow mb-3">
                ACTIVIDADES DE AVENTURA – YACA ADVENTURE
            </h1>
            <p class="fs-5 text-light mx-auto" style="max-width: 800px;">
                Descubre nuestras experiencias únicas en la naturaleza, vive la adrenalina y la aventura con nosotros 🌄
            </p>
        </div>
    </div>

    <!-- Sección de actividades -->
    <section class="activities py-5" style="background: #f9fafb;">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="fw-bold text-success">Explora nuestras actividades</h2>
                <div class="divider mx-auto my-3" 
                     style="width: 80px; height: 3px; background-color: #198754; border-radius: 10px;"></div>
                <p class="text-muted fs-5">
                    Elige tu próxima aventura y reserva fácilmente desde tu celular o computadora.
                </p>
            </div>

            <div class="row g-4">
                @foreach ($activities as $activity)
                  <div class="col-md-6 col-lg-4">
                    <div class="card border-0 shadow-sm h-100">
                      <div class="position-relative">
                        <img src="/img/activities/{{ $activity->image }}" 
                             class="card-img-top rounded-top" 
                             alt="{{ $activity->title }}"
                             style="height: 220px; object-fit: cover;">
                        <span class="badge bg-success position-absolute top-0 end-0 m-2 px-3 py-2">
                          S/ {{ number_format($activity->price, 2) }}
                        </span>
                      </div>
                      <div class="card-body d-flex flex-column">
                        <h5 class="fw-bold mb-2">{{ $activity->title }}</h5>
                        <p class="text-muted mb-3" style="min-height: 70px;">
                          {{ Str::limit(strip_tags($activity->description), 100, '...') }}
                        </p>
                        <ul class="list-unstyled small text-secondary mb-3">
                          <li><i class="bi bi-geo-alt-fill text-success me-1"></i> {{ $activity->location ?? 'No especificada' }}</li>
                          <li><i class="bi bi-clock-fill text-success me-1"></i> {{ $activity->duration ?? 'Duración variable' }}</li>
                        </ul>
                        <div class="mt-auto">
                          <a href="{{ url('activities') }}/{{ $activity->id }}" 
                             class="btn btn-outline-success w-100 rounded-pill">
                            <i class="bi bi-eye me-1"></i> Ver detalle
                          </a>
                        </div>
                      </div>
                    </div>
                  </div>
                @endforeach
            </div>

            @if($activities->isEmpty())
                <div class="text-center py-5 text-muted">
                    <i class="bi bi-info-circle fs-1 d-block mb-2"></i>
                    <p class="fs-5">No hay actividades disponibles por el momento.</p>
                </div>
            @endif
        </div>
    </section>
</main>

<style>
  .text-shadow {
    text-shadow: 0 2px 8px rgba(0,0,0,0.8);
  }
</style>

@endsection
