<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Panel de Administración')</title>

    <!-- ✅ Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
          integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">

    <!-- ✅ Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

    <!-- ✅ SweetAlert2 (para alertas elegantes) -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>


    <style>
        body {
            background-color: #f8f9fa;
            font-family: "Segoe UI", Roboto, Arial, sans-serif;
        }

        /* Sidebar */
        .sidebar {
            position: fixed;
            top: 0;
            bottom: 0;
            left: 0;
            width: 240px;
            background-color: #212529;
            color: #fff;
            padding-top: 60px;
        }

        .sidebar a {
            display: block;
            color: #adb5bd;
            text-decoration: none;
            padding: 12px 20px;
            transition: all 0.2s ease-in-out;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background-color: #0d6efd;
            color: #fff;
        }

        /* Navbar superior */
        .navbar {
            position: fixed;
            top: 0;
            left: 240px;
            right: 0;
            background-color: #fff;
            border-bottom: 1px solid #dee2e6;
            z-index: 1000;
            height: 60px;
        }

        .navbar-brand {
            font-weight: 600;
            color: #0d6efd !important;
        }

        /* Contenido principal */
        .content {
            margin-left: 240px;
            margin-top: 70px;
            padding: 20px;
        }

        /* Logout */
        .logout-form button {
            border: none;
            background: transparent;
            color: #dc3545;
            font-weight: 500;
        }

        .logout-form button:hover {
            text-decoration: underline;
        }

        /* Alertas */
        .alert {
            margin-bottom: 1rem;
        }
    </style>
</head>
<body>

    <!-- Sidebar -->
    <div class="sidebar">
        <h5 class="text-center text-white mb-4">🧭 Panel Admin</h5>
        <a href="/admin/activities" class="{{ request()->is('admin/activities') ? 'active' : '' }}">
            <i class="bi bi-speedometer2 me-2"></i>Actividades
        </a>
        <a href="/admin/restaurant-dishes" class="{{ request()->is('admin/restaurant-dishes') ? 'active' : '' }}">
            <i class="bi bi-speedometer2 me-2"></i> Restaurante
        </a>
        <a href="/admin/users" class="{{ request()->is('admin/users*') ? 'active' : '' }}">
            <i class="bi bi-people me-2"></i>Usuarios
        </a>
        <a href="/admin/posts" class="{{ request()->is('admin/posts*') ? 'active' : '' }}">
            <i class="bi bi-journal-text me-2"></i>Blog
        </a>
        <a href="/admin/products" class="{{ request()->is('admin/products*') ? 'active' : '' }}">
            <i class="bi bi-bag me-2"></i>Tienda
        </a>
        <hr class="text-secondary">
        <form method="POST" action="{{ route('logout') }}" class="logout-form px-3">
            @csrf
            <button type="submit">
                <i class="bi bi-box-arrow-right me-2"></i>Cerrar sesión
            </button>
        </form>
    </div>

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-light px-4">
        <div class="container-fluid">
            <span class="navbar-brand">Panel de Administración</span>
        </div>
    </nav>

    <!-- Contenido principal -->
    <main class="content">
        <div class="container-fluid">

            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle-fill me-2"></i>{{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle-fill me-2"></i>{{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @yield('content')
        </div>
    </main>

    <!-- ✅ Bootstrap JS CDN -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
            integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz"
            crossorigin="anonymous"></script>

</body>
</html>
