<div class="row">
    <div class="col-md-6 mb-3">
        <label class="form-label fw-semibold">Título</label>
        <input type="text" name="title" class="form-control"
               value="{{ old('title', $activity->title ?? '') }}" required>
    </div>

    <div class="col-md-6 mb-3">
        <label class="form-label fw-semibold">Duración</label>
        <input type="text" name="duration" class="form-control"
               value="{{ old('duration', $activity->duration ?? '') }}" required>
    </div>

    <div class="col-md-6 mb-3">
        <label class="form-label fw-semibold">Temporada</label>
        <input type="text" name="season" class="form-control"
               value="{{ old('season', $activity->season ?? '') }}" required>
    </div>

    <div class="col-md-6 mb-3">
        <label class="form-label fw-semibold">Nivel de dificultad</label>
        <input type="text" name="difficulty_level" class="form-control"
               value="{{ old('difficulty_level', $activity->difficulty_level ?? '') }}" required>
    </div>

    <div class="col-md-12 mb-3">
        <label class="form-label fw-semibold">Ubicación</label>
        <input type="text" name="location" class="form-control"
               value="{{ old('location', $activity->location ?? '') }}" required>
    </div>

    <div class="col-md-12 mb-3">
        <label class="form-label fw-semibold">Descripción</label>
        <textarea name="description" rows="3" class="form-control" required>{{ old('description', $activity->description ?? '') }}</textarea>
    </div>

    <div class="col-md-12 mb-3">
        <label class="form-label fw-semibold">Itinerario</label>
        <textarea name="itinerary" rows="3" class="form-control">{{ old('itinerary', $activity->itinerary ?? '') }}</textarea>
    </div>

    <div class="col-md-6 mb-3">
        <label class="form-label fw-semibold">Incluye</label>
        <textarea name="includes" rows="2" class="form-control">{{ old('includes', $activity->includes ?? '') }}</textarea>
    </div>

    <div class="col-md-6 mb-3">
        <label class="form-label fw-semibold">No incluye</label>
        <textarea name="not_includes" rows="2" class="form-control">{{ old('not_includes', $activity->not_includes ?? '') }}</textarea>
    </div>

    <div class="col-md-6 mb-3">
        <label class="form-label fw-semibold">Precio (USD)</label>
        <input type="number" step="0.01" name="price" class="form-control"
               value="{{ old('price', $activity->price ?? '') }}" required>
    </div>

    <div class="col-md-6 mb-3">
        <label class="form-label fw-semibold">Cantidad de personas</label>
        <input type="number" name="people_count" class="form-control"
               value="{{ old('people_count', $activity->people_count ?? 1) }}" required>
    </div>

    <div class="col-md-12 mb-3">
        <label class="form-label fw-semibold">Imagen</label>
        <input type="file" name="image" class="form-control">
        @if(isset($activity) && $activity->image)
            <div class="mt-2">
                <img src="{{ asset($activity->image) }}" alt="Imagen de actividad"
                     class="img-thumbnail" style="max-height: 150px;">
            </div>
        @endif
    </div>
</div>