<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RestaurantSetting extends Model
{
    protected $table = 'restaurant_settings';

    protected $fillable = [
        'title',
        'description',
        'environment',
        'experience',
        'location',
        'schedule',
    ];

    // Charset y collation por seguridad (aunque lo ideal es definirlo en la BD directamente)
    protected $attributes = [
        'charset' => 'utf8mb4',
        'collation' => 'utf8mb4_unicode_ci',
    ];

    // Por si deseas usar timestamps (created_at, updated_at)
    public $timestamps = true;
}
